require "Items/SuburbsDistributions"

Distributions = Distributions or {};

local distributions = {
    gasstore = {
        counter = {
            items = {
                "PaintYourRide.CataloguePaintSpray", 0.05,
                "PaintYourRide.CataloguePaintTints", 0.02,
                "PaintYourRide.VehiclePaintingMag1", 0.08,
                "PaintYourRide.VehiclePaintingMag2", 0.08,
                "PaintYourRide.WireBrush", 0.8,
            },
        },
        shelves = {
            "PaintYourRide.WireBrush", 0.8,
            -- Spray paint: only common colors
            "PaintYourRide.AutomotiveSprayPaintBlack", 0.2,
            "PaintYourRide.AutomotiveSprayPaintBlue", 0.2,
            "PaintYourRide.AutomotiveSprayPaintGreen", 0.2,
            "PaintYourRide.AutomotiveSprayPaintGrey", 0.2,
            "PaintYourRide.AutomotiveSprayPaintRed", 0.2,
            "PaintYourRide.AutomotiveSprayPaintWhite", 0.2,
        },
    },
    gasstorage = {
        metal_shelves = {
            items = {
                -- Spray paint: only common colors
                "PaintYourRide.AutomotiveSprayPaintBlack", 0.3,
                "PaintYourRide.AutomotiveSprayPaintBlue", 0.3,
                "PaintYourRide.AutomotiveSprayPaintGreen", 0.3,
                "PaintYourRide.AutomotiveSprayPaintGrey", 0.3,
                "PaintYourRide.AutomotiveSprayPaintRed", 0.3,
                "PaintYourRide.AutomotiveSprayPaintWhite", 0.3,
            },
        },
    },
    loggingfactory = {
        crate = {
            items = {
                -- "Glasses_SafetyGoggles", 0.3, -- already in-game
                "Hat_DustMask", 0.3,
                -- Spray paint: only some colors
                "PaintYourRide.AutomotiveSprayPaintBlack", 0.5,
                "PaintYourRide.AutomotiveSprayPaintGreen", 0.5,
                "PaintYourRide.AutomotiveSprayPaintGrey", 0.5,
                "PaintYourRide.AutomotiveSprayPaintGreySteel", 0.5,
                "PaintYourRide.AutomotiveSprayPaintBrownDarkChocolate", 0.5,
                "PaintYourRide.AutomotiveSprayPaintBrownRusty", 0.5,
            },
        },
    },
    zippeestore = {
        shelvesmag = {
            items = {
                "PaintYourRide.VehiclePaintingMag1", 0.2,
                "PaintYourRide.VehiclePaintingMag2", 0.2,
            },
        },
    },
    all = {
        crate = {
            items = {
                "PaintYourRide.WireBrush", 0.4,
                "PaintYourRide.SprayGun", 0.2,
                "PaintYourRide.AutomotiveSprayPrimer", 0.5,
                "PaintYourRide.AutomotivePaintWhite", 0.5,
                "PaintYourRide.BoxAutomotivePaintTints", 0.4,
                "PaintYourRide.BoxAutomotivePaintSprays1", 0.4,
                "PaintYourRide.BoxAutomotivePaintSprays2", 0.3,
                "PaintYourRide.BoxAutomotivePaintSprays3", 0.2,
                "PaintYourRide.BoxAutomotivePaintSprays4", 0.1,
            },
        },
        desk = {
            items = {
                "PaintYourRide.CataloguePaintSpray", 0.5,
                "PaintYourRide.CataloguePaintTints", 0.2,
            },
        },
        metal_shelves = {
            items = {
                "PaintYourRide.AutomotiveSprayPrimer", 0.3,
                "PaintYourRide.AutomotivePaintWhite", 0.3,
                "PaintYourRide.BoxAutomotivePaintTints", 0.2,
                "PaintYourRide.BoxAutomotivePaintSprays1", 0.2,
                "PaintYourRide.BoxAutomotivePaintSprays2", 0.15,
                "PaintYourRide.BoxAutomotivePaintSprays3", 0.1,
                "PaintYourRide.BoxAutomotivePaintSprays4", 0.05,
            },
        },
        postbox = {
            items = {
                "PaintYourRide.CataloguePaintSpray", 0.05,
                "PaintYourRide.CataloguePaintTints", 0.03,
                "PaintYourRide.VehiclePaintingMag1", 0.1,
                "PaintYourRide.VehiclePaintingMag2", 0.1,
            },
        },
        shelves = {
            items = {
                "PaintYourRide.CataloguePaintSpray", 0.1,
                "PaintYourRide.CataloguePaintTints", 0.05,
                "PaintYourRide.VehiclePaintingMag1", 0.8,
                "PaintYourRide.VehiclePaintingMag2", 0.8,
            },
        },
        sidetable = {
            items = {
                "PaintYourRide.CataloguePaintSpray", 0.25,
                "PaintYourRide.CataloguePaintTints", 0.12,
                "PaintYourRide.VehiclePaintingMag1", 0.5,
                "PaintYourRide.VehiclePaintingMag2", 0.5,
            },
        },
    },
    shed = {
        other = {
            items = {
                "Glasses_SafetyGoggles", 0.5,
                "Hat_DustMask", 1,
                "PaintYourRide.VehiclePaintingMag1", 0.2,
                "PaintYourRide.VehiclePaintingMag2", 0.2,
                "PaintYourRide.WireBrush", 1,
                "PaintYourRide.SprayGun", 0.5,
                "PaintYourRide.AutomotiveSprayPrimer", 0.5,
                "PaintYourRide.AutomotivePaintWhite", 0.5,
                "PaintYourRide.BoxAutomotivePaintTints", 0.2,
                "PaintYourRide.BoxAutomotivePaintSprays1", 0.4,
                "PaintYourRide.BoxAutomotivePaintSprays2", 0.2,
                "PaintYourRide.BoxAutomotivePaintSprays3", 0.1,
                "PaintYourRide.BoxAutomotivePaintSprays4", 0.05,
            },
        },
    },
    garagestorage = {
        other = {
            items = {
                "PaintYourRide.VehiclePaintingMag1", 0.2,
                "PaintYourRide.VehiclePaintingMag2", 0.2,
                "PaintYourRide.WireBrush", 1,
                "PaintYourRide.SprayGun", 0.5,
                "PaintYourRide.AutomotiveSprayPrimer", 0.5,
                "PaintYourRide.AutomotivePaintWhite", 0.5,
                "PaintYourRide.BoxAutomotivePaintTints", 0.4,
                "PaintYourRide.BoxAutomotivePaintSprays1", 0.4,
                "PaintYourRide.BoxAutomotivePaintSprays2", 0.3,
                "PaintYourRide.BoxAutomotivePaintSprays3", 0.2,
                "PaintYourRide.BoxAutomotivePaintSprays4", 0.1,
            },
        },
        bin = {
            items = {
                "PaintYourRide.CataloguePaintSpray", 0.8,
                "PaintYourRide.CataloguePaintTints", 0.5,
            },
        },
    },
    garage = {
        metal_shelves = {
            items = {
                "Glasses_SafetyGoggles", 0.5,
                "Hat_DustMask", 1,
                "PaintYourRide.VehiclePaintingMag1", 0.2,
                "PaintYourRide.VehiclePaintingMag2", 0.2,
                "PaintYourRide.WireBrush", 0.5,
                "PaintYourRide.SprayGun", 0.2,
                -- TODO: Paint same as garagestorage ?
            },
        },
    },
    bookstore = {
        other = {
            items = {
                "PaintYourRide.VehiclePaintingMag1", 0.8,
                "PaintYourRide.VehiclePaintingMag2", 0.8,
            },
        },
    },
    toolstore = {
        shelves = {
            items = {
                "Glasses_SafetyGoggles", 0.5,
                "Hat_DustMask", 0.5,
                "PaintYourRide.VehiclePaintingMag1", 0.1,
                "PaintYourRide.VehiclePaintingMag2", 0.1,
            },
        },
        counter = {
            items = {
                "Glasses_SafetyGoggles", 0.5,
                "Hat_DustMask", 0.5,
                "PaintYourRide.VehiclePaintingMag1", 0.1,
                "PaintYourRide.VehiclePaintingMag2", 0.1,
            },
        },
    },
    mechanic = {
        -- not used?
        wardrobe = {
            items = {
                "Boilersuit_BlueRed", 2,
                "Glasses_SafetyGoggles", 0.5,
                "Hat_DustMask", 0.5,
                "PaintYourRide.CataloguePaintSpray", 0.5,
                "PaintYourRide.CataloguePaintTints", 0.2,
                "PaintYourRide.VehiclePaintingMag1", 1,
                "PaintYourRide.VehiclePaintingMag2", 1,
            },
        },
        metal_shelves = {
            items = {
                "Glasses_SafetyGoggles", 0.5,
                "Hat_DustMask", 0.5,
                "PaintYourRide.CataloguePaintSpray", 0.2,
                "PaintYourRide.CataloguePaintTints", 0.1,
                "PaintYourRide.VehiclePaintingMag1", 0.3,
                "PaintYourRide.VehiclePaintingMag2", 0.3,
                -- Tools
                "PaintYourRide.WireBrush", 1,
                "PaintYourRide.SprayGun", 0.8,
                -- Primer
                "PaintYourRide.AutomotiveSprayPrimer", 1,
                "PaintYourRide.AutomotiveSprayPrimer", 1,
                -- Spray paint: all
                "PaintYourRide.AutomotiveSprayPaintBlack", 1,
                "PaintYourRide.AutomotiveSprayPaintBlue", 1,
                "PaintYourRide.AutomotiveSprayPaintGreen", 1,
                "PaintYourRide.AutomotiveSprayPaintGrey", 1,
                "PaintYourRide.AutomotiveSprayPaintRed", 1,
                "PaintYourRide.AutomotiveSprayPaintWhite", 1,
                "PaintYourRide.AutomotiveSprayPaintBlueOlympic", 0.33,
                "PaintYourRide.AutomotiveSprayPaintBrownRusty", 0.33,
                "PaintYourRide.AutomotiveSprayPaintGreenForest", 0.33,
                "PaintYourRide.AutomotiveSprayPaintGreySteel", 0.33,
                "PaintYourRide.AutomotiveSprayPaintOrangeTangerine", 0.33,
                "PaintYourRide.AutomotiveSprayPaintPinkBubbleGum", 0.33,
                "PaintYourRide.AutomotiveSprayPaintRedCandyApple", 0.33,
                "PaintYourRide.AutomotiveSprayPaintVioletGrape", 0.33,
                "PaintYourRide.AutomotiveSprayPaintYellow", 0.33,
                "PaintYourRide.AutomotiveSprayPaintBlueNavy", 0.11,
                "PaintYourRide.AutomotiveSprayPaintBrownDarkChocolate", 0.11,
                "PaintYourRide.AutomotiveSprayPaintGreenArmy", 0.11,
                "PaintYourRide.AutomotiveSprayPaintPinkGlamorous", 0.11,
                "PaintYourRide.AutomotiveSprayPaintRedBurgundy", 0.11,
                "PaintYourRide.AutomotiveSprayPaintYellowTuscany", 0.11,
                "PaintYourRide.AutomotiveSprayPaintBlueNeon", 0.03,
                "PaintYourRide.AutomotiveSprayPaintGreenNeon", 0.03,
                "PaintYourRide.AutomotiveSprayPaintVioletIndigo", 0.03,
                "PaintYourRide.AutomotiveSprayPaintYellowNeon", 0.03,
                -- Mix paint
                "PaintYourRide.AutomotivePaintWhite", 1,
                "PaintYourRide.AutomotivePaintWhite", 1,
                "PaintYourRide.AutomotiveTintPaintBlack", 0.7,
                "PaintYourRide.AutomotiveTintPaintBlue", 0.7,
                "PaintYourRide.AutomotiveTintPaintCyan", 0.7,
                "PaintYourRide.AutomotiveTintPaintGreen", 0.7,
                "PaintYourRide.AutomotiveTintPaintMagenta", 0.7,
                "PaintYourRide.AutomotiveTintPaintRed", 0.7,
                "PaintYourRide.AutomotiveTintPaintYellow", 0.7,
            },
        },
    },
    poststorage = {
        all = {
            items = {
                "PaintYourRide.CataloguePaintSpray", 0.15,
                "PaintYourRide.CataloguePaintTints", 0.08,
                "PaintYourRide.VehiclePaintingMag1", 0.3,
                "PaintYourRide.VehiclePaintingMag2", 0.3,
            },
        },
    },
    storageunit = {
        all = {
            items = {
                "PaintYourRide.WireBrush", 0.7,
                "PaintYourRide.SprayGun", 0.3,
                "PaintYourRide.AutomotiveSprayPrimer", 0.4,
                "PaintYourRide.AutomotivePaintWhite", 0.4,
                "PaintYourRide.BoxAutomotivePaintTints", 0.4,
                "PaintYourRide.BoxAutomotivePaintSprays1", 0.4,
                "PaintYourRide.BoxAutomotivePaintSprays2", 0.3,
                "PaintYourRide.BoxAutomotivePaintSprays3", 0.2,
                "PaintYourRide.BoxAutomotivePaintSprays4", 0.1,
            },
        },
    },
    cornerstore = {
        shelvesmag = {
            items = {
                "PaintYourRide.VehiclePaintingMag1", 0.2,
                "PaintYourRide.VehiclePaintingMag2", 0.2,
            },
        },
    },
}

table.insert(Distributions, distributions)

-- Add new crate to the procedural lists
table.insert(SuburbsDistributions["warehouse"]["crate"].procList, { name = "CrateAutomotivePaint", min = 0, max = 12 })
table.insert(SuburbsDistributions["garagestorage"]["crate"].procList, { name = "CrateAutomotivePaint", min = 0, max = 12 })
table.insert(SuburbsDistributions["garage"]["crate"].procList, { name = "CrateAutomotivePaint", min = 0, max = 12 })
